@extends('backend.layouts.master')

@section('title')
  {{ 'Order Manage' . ' - ' . $title }}
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ __('Order Status') }}</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{route('home') }}">{{ __('Dashboard') }}</a>
            </li>
            @if(helper::roleAccess('order.status.index'))
              <li class="breadcrumb-item">
                <a href="{{route('order.status.index') }}">{{ __('Status') }}</a>
              </li>
            @endif
            <li class="breadcrumb-item active">
              <span>{{ $title }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">{{ __('Add New Status') }}</h3>
          <div class="card-tools">
            @if(helper::roleAccess('order.status.index'))
              <a class="btn btn-default" href="{{ route('order.status.index') }}">
                <i class="fa fa-list"></i>
                <span>{{ __('Status List') }}</span>
              </a>
            @endif
            <span id="buttons"></span>
            <a class="btn btn-tool btn-default" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </a>
            <a class="btn btn-tool btn-default" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div><!-- /.card-header -->
        <div class="card-body">
          <form class="needs-validation" method="POST" action="{{ route('order.status.store') }}" novalidate>
            @csrf
            <div class="form-row">
              <div class="col-md-6 mb-3">
                <label for="title">{{ __('Title * :') }}</label>
                <input type="text" name="title" class="form-control" id="title" placeholder="Title" value="{{ old('title') }}" />
                @error('title')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>
              <div class="col-md-6 mb-3">
                <label for="orderBy">{{ __('Order No. * :') }}</label>
                  <input type="number" name="order_by" class="form-control" id="orderBy" placeholder="Order No" value="{{ old('order_by') }}" />
                  @error('order_by')
                    <span class=" error text-red text-bold">{{ $message }}</span>
                  @enderror
              </div>         
            </div>       
            <button class="btn btn-info" type="submit">
              <i class="fa fa-save"></i>
              <span>&nbsp;{{ __('Save') }}</span>
            </button>
          </form>
        </div><!-- /.card-body -->
        <div class="card-footer"></div>
      </div>
    </div><!-- /.col-->
  </section>
@endsection