@extends('backend.layouts.master')

@section('title')
  {{ 'Order Manage' . ' - ' . $title}}
@endsection

@section('styles')
  <style>
    .bootstrap-switch-large { width: 200px; }
  </style>
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ __('Order Status') }}</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{route('home') }}">{{ __('Dashboard') }}</a>
            </li>
            @if(helper::roleAccess('order.status.index'))
              <li class="breadcrumb-item">
                <a href="{{route('order.status.index') }}">{{ __('Status') }}</a>
              </li>
            @endif
            <li class="breadcrumb-item active">
              <span>{{ $title }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">{{ $title }}</h3>
          <div class="card-tools">
            @if(helper::roleAccess('order.status.create'))
              <a class="btn btn-sm btn-default" href="{{ route('order.status.create') }}">
                <i class="fas fa-plus"></i>
                <span>{{ __('Add New') }}</span>
              </a>
            @endif
            <a class="btn btn-tool btn-default" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </a>
            <a class="btn btn-tool btn-default" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div><!-- /.card-header -->
        <div class="card-body">
          <span id="buttons"></span>
          <div class="table-responsive mt-2">
            <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
              <thead>
                <tr>
                  <th>{{ __('SL') }}</th>
                  <th>{{ __('Title') }}</th>
                  <th>{{ __('Order By') }}</th>
                  <th>{{ __('Action') }}</th>
                </tr>
              </thead>
              <tbody></tbody>
              <tfoot>
                <tr>
                  <th>{{ __('SL') }}</th>
                  <th>{{ __('Title') }}</th>
                  <th>{{ __('Order By') }}</th>
                  <th>{{ __('Action') }}</th>
                </tr>
              </tfoot>
            </table>
          </div>
        </div><!-- /.card-body -->
        <div class="card-footer"></div>
      </div>
    </div><!-- /.col-->
  </section>
@endsection

@section('scripts')
  @include('backend.pages.order.status.script')
@endsection