@extends('backend.layouts.master')

@section('title', 'Show Stock In')

@section('navbar-content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Show Stock In</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('stockin.list') }}">Stock In</a></li>
                    <li class="breadcrumb-item active">Show</li>
                </ol>
            </div>
        </div>
    </div>
</div>
@endsection

@section('admin-content')
<div class="row justify-content-center">
    <div class="col-md-11">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Stock In Details</h3>
            </div>

            <div class="card-body">
              

                {{-- Dynamic Stock In Details --}}
                <div id="additional-fields-container" class="mt-3">
                    @foreach ($stockIn->stock_in_details as $details)
                    <div class="row dynamic-row">
                        {{-- Description --}}
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="description">Description</label>
                                <input type="text" class="form-control" value="{{ $details->description }}" readonly>
                            </div>
                        </div>

                        {{-- In Quantity --}}
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="in_quantity">In Quantity</label>
                                <input type="number" class="form-control" value="{{ $details->in_quantity }}" readonly>
                            </div>
                        </div>

                        {{-- Price --}}
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="price">Price</label>
                                <input type="number" class="form-control" value="{{ $details->price }}" readonly>
                            </div>
                        </div>

                        {{-- Accessory Name --}}
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="accessory_name">Accessory Name</label>
                                <input type="text" class="form-control" value="{{ $details->accessories->name }}" readonly>
                            </div>
                        </div>

                        {{-- Unit --}}
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="unit">Unit</label>
                                <input type="text" class="form-control" value="{{ $details->accessories->unit }}" readonly>
                            </div>
                        </div>

                        {{-- KG --}}
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="kg">KG</label>
                                <input type="text" class="form-control" value="{{ $details->kg }}" readonly>
                            </div>
                        </div>

                        {{-- Total Price --}}
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="total_price">Total Price</label>
                                <input type="text" class="form-control" value="{{ $details->total_price }}" readonly>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <div class="card-footer">
                <a href="{{ route('stockin.list') }}" class="btn btn-secondary">Back to List</a>
            </div>
        </div>
    </div>
</div>

@endsection
