@extends('frontant.layouts.auth')

@section('title')
  {{ __('Login') }}
@endsection

@section('styles')
  <style></style>
@endsection

@section('note')
  <p class="login-box-msg">{{ __('Sign in to start your session') }}</p>
@endsection

@section('content')
  <form method="POST" action="{{ route('buyer.submit') }}">
    @csrf
    <div class="input-group mb-3">
      <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus />
      <div class="input-group-append">
        <div class="input-group-text">
          <span class="fas fa-envelope"></span>
        </div>
      </div>
      @error('email')
        <span class="invalid-feedback" role="alert">
          <strong>{{ $message }}</strong>
        </span>
      @enderror
    </div>
    <div class="input-group mb-3">
      <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password" />
      <div class="input-group-append">
        <div class="input-group-text">
          <span class="fas fa-lock"></span>
        </div>
      </div>
      @error('password')
        <span class="invalid-feedback" role="alert">
          <strong>{{ $message }}</strong>
        </span>
      @enderror
    </div>
    <div class="d-flex justify-content-between align-items-center">
      <div class="icheck-primary">
        <input type="checkbox" id="remember" />
        <label for="remember">{{ __('Remember Me') }}</label>
      </div>
      <p class="mb-1">
        <a href="javascript:void(0)">{{ __('I forgot my password') }}</a>
      </p>
    </div>
    <button type="submit" class="btn btn-primary btn-block mt-2">{{ __('Sign In') }}</button>
  </form>
  <div class="mt-3">
    <p class="text-center">{{ __('Need an account!') }}</p>
    <a href="{{ route('buyer.registration') }}" class="btn btn-secondary btn-block">
      <span>{{ __('Register here') }}</span>
    </a>
  </div>
@endsection

@section('scripts')
  <script></script>
@endsection
