@extends('backend.layouts.master')

@section('title', 'Create Stock In')

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Create Stock In</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('stockin.list') }}">Stock In</a></li>
                        <li class="breadcrumb-item active">Create</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('admin-content')
    <div class="row justify-content-center">
        <div class="col-md-11">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">New Stock In</h3>
                </div>

                <form action="{{ route('stockin.store') }}" method="POST" id="create-stockin-form">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            {{-- Accessory Name Field --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="accessory_name">Accessory Name</label>
                                    <select name="accessory_name" id="accessory_name"
                                        class="form-control @error('accessory_name') is-invalid @enderror" required>
                                        <option value="">Select Accessory</option>
                                        @foreach (App\Models\Accesories::all() as $accessory)
                                            <option value="{{ $accessory->name }}" data-id="{{ $accessory->id }}"
                                                data-unit="{{ $accessory->unit }}">
                                                {{ $accessory->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('accessory_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- Unit Field --}}
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="unit">Unit</label>
                                    <input type="text" name="unit" id="unit"
                                        class="form-control @error('unit') is-invalid @enderror" value="{{ old('unit') }}"
                                        placeholder="Unit will be auto-filled" readonly required>
                                    @error('unit')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- Append Button (with Plus Icon) --}}
                            <div class="col-md-2 d-flex align-items-end mb-3 ">
                                <button type="button" id="append-fields" class="btn btn-secondary w-100 p-2">
                                    <i class="fa fa-plus"></i>
                                </button>
                            </div>
                        </div>

                        {{-- Dynamic Fields Container --}}
                        <div id="additional-fields-container" class="mt-3"></div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Create</button>
                        <a href="{{ route('stockin.list') }}" class="btn btn-secondary">Back to List</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        // Handle accessory selection and populate unit field using AJAX
        $('#accessory_name').on('change', function() {
            var accessoryName = $(this).val(); // Get the selected accessory name
            var accessoryId = $(this).find(':selected').data('id'); // Get the selected accessory ID
            var unit = $(this).find(':selected').data('unit'); // Get the selected accessory unit

            if (accessoryName) {
                // Populate the unit field
                $('#unit').val(unit);
            } else {
                $('#unit').val(''); // Clear the unit if no accessory is selected
            }
        });

        // Handle append button click to add fields dynamically
        let rowCount = 0; // Counter for unique IDs

        $('#append-fields').on('click', function() {
            var accessoryName = $('#accessory_name').val();
            var accessoryId = $('#accessory_name').find(':selected').data(
            'id'); // Get the selected accessory ID
            var unit = $('#unit').val();

            if (accessoryName && unit) {
                rowCount++; // Increment counter for unique IDs
                var newFields = `
                    <div class="row dynamic-row" id="row-${rowCount}">

                                      <div class="col-md-4">
    <div class="form-group">
        <label for="description">Description</label>
        <textarea name="description[]" class="form-control" rows="3" placeholder="Enter description" required></textarea>
    </div>
</div>
                     
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="in_quantity">In Quantity</label>
                                <input type="number" name="in_quantity[]" class="form-control" placeholder="Enter quantity" required>
                            </div>
                        </div>
          
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="accessory_id">Accessory Name</label>
                                <input type="hidden" name="accessory_id[]" value="${accessoryId}">
                                <input type="text" class="form-control" value="${accessoryName}" readonly>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="unit">Unit</label>
                                <input type="text" class="form-control" value="${unit}" readonly>
                            </div>
                        </div>
                        <div class="col-md-2 align-self-end mb-3">
                            <button type="button" class="btn btn-danger remove-row" data-row-id="row-${rowCount}">
                                <i class="fa fa-trash"></i> Remove
                            </button>
                        </div>
                    </div>
                `;
                $('#additional-fields-container').append(newFields);
            } else {
                alert('Please select an accessory and unit before appending fields.');
            }
        });

        // Handle removal of appended rows
        $(document).on('click', '.remove-row', function() {
            var rowId = $(this).data('row-id');
            $('#' + rowId).remove();
        });
    });
</script>
@push('scripts')
@endpush
